﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Framework
{
    /// <summary>
    /// アプリケーションのプレゼンターです。
    /// </summary>
    public abstract class ApplicationPresenter : Presenter
    {
        /// <summary>
        /// アプリケーションを終了可能かどうか調べます。
        /// </summary>
        /// <returns>終了可能な場合は true、不可能な場合は false を返します。</returns>
        public virtual bool CanExit()
        {
            return true;
        }

        public object Run()
        {
            return this.OnRun();
        }

        public int Exit()
        {
            return this.OnExit();
        }

        protected virtual object OnRun()
        {
            return null;
        }

        protected virtual int OnExit()
        {
            return 0;
        }
    }
}
