﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;

namespace NintendoWare.Spy.Framework.Windows
{
    /// <summary>
    /// ウィンドウを表示するプレゼンターです。
    /// </summary>
    public abstract class SimpleWindowPresenter : Presenter
    {
        private Window _window;

        //-----------------------------------------------------------------

        protected virtual bool IsModal
        {
            get { return true; }
        }

        //-----------------------------------------------------------------

        public object Run()
        {
            return this.OnRun();
        }

        /// <summary>
        /// ウィンドウを生成します。
        /// </summary>
        /// <returns>生成したウィンドウを返します。</returns>
        protected abstract Window CreateWindow();

        protected virtual void PreShowWindow()
        {
        }

        protected override void OnUninitialize()
        {
            if (_window != null)
            {
                _window.Close();
                _window = null;
            }
        }

        protected virtual object OnRun()
        {
            if (_window == null)
            {
                _window = this.CreateWindow();
            }

            this.PreShowWindow();

            if (this.IsModal)
            {
                return _window.ShowDialog();
            }
            else
            {
                _window.Show();
                return null;
            }
        }
    }
}
