﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Foundation
{
    /// <summary>
    /// IDeepClonable の機能拡張を提供します。
    /// </summary>
    public static class IDeepClonableExtension
    {
        /// <summary>
        /// 指定オブジェクトをディープクローンします。
        /// </summary>
        /// <typeparam name="TObject">対象オブジェクトの型を指定します。</typeparam>
        /// <param name="target">オブジェクトを指定します。</param>
        /// <returns>指定オブジェクトのディープクローンを返します。</returns>
        public static TObject DeepClone<TObject>(this TObject target)
            where TObject : IDeepClonable
        {
            Ensure.Argument.NotNull(target);
            return (TObject)target.DeepClone();
        }
    }
}
