﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;

namespace NintendoWare.Spy.Foundation.Communications
{
    /// <summary>
    /// 通信チャンネルを制御します。
    /// </summary>
    public interface IComChannel : IDisposable
    {
        /// <summary>
        /// ポート番号を取得します。
        /// </summary>
        int Port { get; }

        /// <summary>
        /// 開閉状態の有無を取得します。
        /// </summary>
        bool IsOpened { get; }

        /// <summary>
        /// 送信タイムアウトを取得または設定します。
        /// </summary>
        int SendTimeout { get; set; }

        /// <summary>
        /// 受信タイムアウトを取得または設定します。
        /// </summary>
        int ReceiveTimeout { get; set; }

        //-----------------------------------------------------------------

        /// <summary>
        /// チャンネルを閉じます。
        /// </summary>
        void Close();

        /// <summary>
        /// ストリームを取得します。
        /// </summary>
        Stream GetStream();
    }
}
