﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Foundation.Communications
{
    /// <summary>
    /// HostIO 機能を提供します。
    /// </summary>
    public sealed class HostIOService : ObservableObject
    {
        private readonly Dictionary<string, IComEndPoint> _hostIOs = new Dictionary<string, IComEndPoint>();

        //-----------------------------------------------------------------

        public void Initialize(IEnumerable<HostIOPlugin> plugins)
        {
            foreach (var plugin in plugins)
            {
                var hostIO = plugin.GetHostIO();

                if (hostIO == null || string.IsNullOrEmpty(plugin.Platform))
                {
                    Assertion.Fail("invalid HostIOPlugin.");
                    continue;
                }

                _hostIOs.Add(plugin.Platform, hostIO);
            }
        }

        public IComEndPoint GetHostIO(string platformName)
        {
            IComEndPoint hostIO = null;
            _hostIOs.TryGetValue(platformName, out hostIO);
            return hostIO;
        }
    }
}
