﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Drawing;

namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// コマンド情報を管理します。
    /// </summary>
    /// TODO : コマンドの戻り値の方を追加する
    public sealed class Command
    {
        private readonly CommandID _id;
        private readonly string _text = string.Empty;
        private readonly Image _image;
        private string _shortcutKeyText = string.Empty;
        private readonly Type _argsType;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="id">コマンドIDを指定します。</param>
        /// <param name="text">コマンドのテキストを指定します。</param>
        /// <param name="image">コマンドのイメージを指定します。</param>
        /// <param name="argsType">コマンド引数の型を指定します。</param>
        public Command(string id, string text, Image image = null, Type argsType = null) :
            this(new CommandID(id), text, image, argsType)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="id">コマンドIDを指定します。</param>
        /// <param name="text">コマンドのテキストを指定します。</param>
        /// <param name="image">コマンドのイメージを指定します。</param>
        /// <param name="argsType">コマンド引数の型を指定します。</param>
        public Command(CommandID id, string text, Image image = null, Type argsType = null)
        {
            Ensure.Argument.NotNull(id);
            _id = id;
            _text = text ?? string.Empty;
            _image = image;
            _argsType = argsType;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// コマンドID を取得します。
        /// </summary>
        public CommandID ID
        {
            get { return _id; }
        }

        /// <summary>
        /// ローカライズされたコマンドテキストを取得します。
        /// </summary>
        public string Text
        {
            get { return _text; }
        }

        /// <summary>
        /// コマンドのイメージを取得します。
        /// </summary>
        public Image Image
        {
            get { return _image; }
        }

        /// <summary>
        /// ショートカットキーテキストを取得または設定します。
        /// </summary>
        public string ShortcutKeyText
        {
            get { return _shortcutKeyText; }
            set { _shortcutKeyText = value ?? string.Empty; }
        }

        /// <summary>
        /// コマンド引数の型を取得します。
        /// </summary>
        public Type ArgsType
        {
            get { return _argsType; }
        }
    }
}
