﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation.Binary;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace NintendoWare.Spy.Communication
{
    /// <summary>
    /// パケットの本体です。
    /// </summary>
    public abstract class PacketBody : IBinarizable
    {
        public abstract uint Size { get; }

        //-----------------------------------------------------------------

        public event EventHandler SizeChanged;

        //-----------------------------------------------------------------

        IEnumerable<PropertyInfo> IBinarizable.GetProperties()
        {
            return this.GetProperties();
        }

        protected abstract IEnumerable<PropertyInfo> GetProperties();

        protected void OnSizeChanged()
        {
            if (this.SizeChanged != null)
            {
                this.SizeChanged(this, EventArgs.Empty);
            }
        }
    }

    /// <summary>
    /// 空のパケット本体です。
    /// </summary>
    public class NullPacketBody : PacketBody
    {
        public override uint Size
        {
            get { return 0; }
        }

        //-----------------------------------------------------------------

        protected override IEnumerable<PropertyInfo> GetProperties()
        {
            yield break;
        }
    }
}
