﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Communication
{
    /// <summary>
    /// Spy データの識別子です。
    /// </summary>
    public enum SpyDataID : uint
    {
        /// <summary>
        /// 無効値です。
        /// </summary>
        Invalid = 0x0,

        /// <summary>
        /// データバージョン（システムで利用）
        /// </summary>
        DataVersion = 0x0,

        //-----------------------------------------------------------------

        /// <summary>
        /// フレーム同期情報
        /// </summary>
        FrameSync = 0x01,

        /// <summary>
        /// API コールログ
        /// </summary>
        ApiCall = 0x02,

        /// <summary>
        /// ボイス情報
        /// </summary>
        VoiceInfo = 0x03,

        /// <summary>
        /// プロファイル情報
        /// </summary>
        Profile = 0x04,

        /// <summary>
        /// 最終出力波形
        /// </summary>
        FinalOut = 0x05,

        /// <summary>
        /// サウンド情報
        /// </summary>
        SoundStatusInfo = 0x06,

        /// <summary>
        /// サウンドラベル
        /// </summary>
        SoundDataInfo = 0x07,

        //-----------------------------------------------------------------

        /// <summary>
        /// DataID の最大値です。
        /// UInt32 でフラグ管理するので上限は 32 になります。
        /// </summary>
        Max = 0x20,
    }
}
