﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using System.Collections.Generic;
using System.IO;

namespace NintendoWare.Spy.Binary
{
    internal class SpyDataListReader : ObservableObject
    {
        private StreamReader _reader;

        //-----------------------------------------------------------------

        public SpyDataListReader(Stream stream)
        {
            Ensure.Argument.NotNull(stream);
            Ensure.Operation.Null(_reader);

            _reader = new StreamReader(stream);
        }

        //-----------------------------------------------------------------

        public void Close()
        {
            this.Dispose();
        }

        public string[] ReadItems()
        {
            var result = new List<string>();

            while (true)
            {
                var line = _reader.ReadLine();

                if (line == null)
                {
                    break;
                }

                if (string.IsNullOrEmpty(line))
                {
                    result.Add(line);
                }
            }

            return result.ToArray();
        }

        protected override void Dispose(bool disposing)
        {
            if (_reader != null)
            {
                _reader.Dispose();
                _reader = null;
            }

            base.Dispose(disposing);
        }
    }
}
