﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics.CodeAnalysis;

namespace NintendoWare.Spy.Binary
{
    internal static class SpyDataBinary
    {
        public static readonly char[] Signature = new char[] { 'S', 'P', 'D', 'B' };

        [SuppressMessage("StyleCop.CSharp.NamingRules", "SA1310:FieldNamesMustNotContainUnderscore", Justification = "バージョン番号のため")]
        public static readonly Version ContainerVersion_3_0_0_0 = new Version(3, 0, 0, 0);

        /// <summary>
        /// コンテナバージョン 3.1.0.0
        /// </summary>
        /// <remarks>
        /// ヘッダーフォーマット：
        /// <code>
        /// byte[4] signature;
        /// byte[4] containerVersion;
        /// ushort bom;
        /// ushort nameLength;
        /// byte[4] dataVersion;
        ///
        /// [Label(DATABLOCK_OFFSET_BASE)]
        /// uint dataBlockOffset; // (DATABLOCK - DATABLOCK_OFFSET_BASE)
        /// uint blockCount;
        /// byte[nameLength] name;
        ///
        /// [Alignment(4)]
        /// [Label(DATABLOCK)]
        /// ...
        /// (以後 DataBlock が続きます)
        /// </code>
        /// </remarks>
        [SuppressMessage("StyleCop.CSharp.NamingRules", "SA1310:FieldNamesMustNotContainUnderscore", Justification = "バージョン番号のため")]
        public static readonly Version ContainerVersion_3_1_0_0 = new Version(3, 1, 0, 0);

        /// <summary>
        /// コンテナバージョン 3.2.0.0
        /// <list type="bullet">
        /// <item>
        /// <description> uint blockCount を long totalDataBlockLength に変更。</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <remarks>
        /// ヘッダーフォーマット：
        /// <code>
        /// byte[4] signature;
        /// byte[4] containerVersion;
        /// ushort bom;
        /// ushort nameLength;
        /// byte[4] dataVersion;
        ///
        /// [Label(DATABLOCK_OFFSET_BASE)]
        /// uint dataBlockOffset; // (DATABLOCK - DATABLOCK_OFFSET_BASE)
        /// long totalDataBlockLength;
        /// byte[nameLength] name;
        ///
        /// [Alignment(4)]
        /// [Label(DATABLOCK)]
        /// ...
        /// (以後 DataBlock が続きます)
        /// </code>
        /// </remarks>
        [SuppressMessage("StyleCop.CSharp.NamingRules", "SA1310:FieldNamesMustNotContainUnderscore", Justification = "バージョン番号のため")]
        public static readonly Version ContainerVersion_3_2_0_0 = new Version(3, 2, 0, 0);
    }

    /// <summary>
    /// Spy データのバイナリヘッダです。
    /// </summary>
    internal class SpyDataBinaryHeader
    {
        public bool IsLittleEndian { get; set; }
        public string DataName { get; set; }
        public Version DataVersion { get; set; }
        public long TotalDataBlockLength { get; set; }
        public Version ContainerVersion { get; set; }
    }
}
