﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Framework;

namespace NintendoWare.Spy
{
    public class SpyFramework : ApplicationFramework
    {
        private static readonly object FieldInstanceLock = new object();
        private static SpyFramework FieldInstance;

        //-----------------------------------------------------------------

        /// <summary>
        /// フレームワークのインスタンスを取得します。
        /// </summary>
        public static SpyFramework CreateInstance()
        {
            lock (FieldInstanceLock)
            {
                Ensure.Operation.Null(FieldInstance);

                FieldInstance = new SpyFramework();
                return FieldInstance;
            }
        }
    }
}
