﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// TimelinePanel.xaml の相互作用ロジック
    /// </summary>
    [TemplatePart(Name = PartScrollViewer, Type = typeof(ScrollViewer))]
    [TemplatePart(Name = PartVerticalScrollBar, Type = typeof(ScrollBar))]
    public partial class TimelinePanel : UserControl
    {
        private const string PartScrollViewer = "PART_ScrollViewer";
        private const string PartVerticalScrollBar = "PART_VerticalScrollBar";

        private static readonly DependencyProperty MarginForPlotCanvasControllerProperty = DependencyProperty.Register(
            nameof(MarginForPlotCanvasController),
            typeof(Thickness),
            typeof(TimelinePanel),
            new FrameworkPropertyMetadata(null));

        private static readonly DependencyProperty MarginForHeaderedListBoxProperty = DependencyProperty.Register(
            nameof(MarginForHeaderedListBox),
            typeof(Thickness),
            typeof(TimelinePanel),
            new FrameworkPropertyMetadata(null));

        private ScrollBar _headeredListBoxVerticalScrollBar;

        public TimelinePanel()
        {
            this.InitializeComponent();

            this.Loaded += (s, e) =>
                {
                    var scrollViewer = (ScrollViewer)this.headeredListBox.Template.FindName(PartScrollViewer, this.headeredListBox);
                    _headeredListBoxVerticalScrollBar = (ScrollBar)scrollViewer.Template.FindName(PartVerticalScrollBar, scrollViewer);

                    this.UpdateMargin();
                };
            this.headeredListBox.ItemHeaderWidthChanged += (s, e) => this.UpdateMargin();
        }

        private Thickness MarginForPlotCanvasController
        {
            get { return (Thickness)GetValue(MarginForPlotCanvasControllerProperty); }
            set { SetValue(MarginForPlotCanvasControllerProperty, value); }
        }

        private Thickness MarginForHeaderedListBox
        {
            get { return (Thickness)GetValue(MarginForHeaderedListBoxProperty); }
            set { SetValue(MarginForHeaderedListBoxProperty, value); }
        }

        private void UpdateMargin()
        {
            if (_headeredListBoxVerticalScrollBar != null)
            {
                var scrollBarWidth = _headeredListBoxVerticalScrollBar.ActualWidth;
                var headerWidth = this.headeredListBox.ItemHeaderWidth;
                this.MarginForPlotCanvasController = new Thickness(headerWidth, 0.0, scrollBarWidth, 0.0);
                this.MarginForHeaderedListBox = new Thickness(-headerWidth, 18.0, -scrollBarWidth, 0.0);
            }
        }
    }
}
