﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Windows
{
    public sealed class TimelineChartValue
    {
        public enum ValueMode
        {
            /// <summary>
            /// 値１つを表示するモードです。
            /// Value を使います。
            /// </summary>
            Scalar,

            /// <summary>
            /// 値の範囲を表示するモードです。
            /// MinValue, MaxValue が値の範囲を表します。
            /// Value は凡例の現在の値に使われます。
            /// </summary>
            MinMax,
        }

        public TimelineChartValue(PlotSpyModel.PlotFloatValue model)
        {
            this.Time = model.Time;
        }

        public SpyTime Time
        {
            get;
            set;
        }

        public double Value { get; set; } = double.NaN;

        public double MinValue { get; set; } = double.NaN;

        public double MaxValue { get; set; } = double.NaN;
    }
}
