﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Plugins;
using System.Windows.Controls;

namespace NintendoWare.Spy.Windows
{
    internal class SpyDebugPanelPresenter : SpyPanelPresenter
    {
        private SpyDebugPanel _view;
        private SpyDebugPanelViewModel _viewModel;

        protected override void OnUninitialize()
        {
            Disposer.SafeDispose(ref _viewModel);

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            _viewModel = new SpyDebugPanelViewModel(this.GetPlaybackService());

            _view = new SpyDebugPanel()
            {
                DataContext = _viewModel,
            };

            return _view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case PlotSpyModelPlugin.SpyDataName:
                    _viewModel.SetPlotModel((PlotSpyModel)model);
                    break;
            }
        }
    }
}
