﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy.Windows.Primitives;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    public class PlotStateValueData : ObservableObject, IPlotStateValue
    {
        private double _rightX = double.NaN;

        public PlotStateValueData(PlotSpyModel.PlotStateValue model)
        {
            this.BeginTime = model.Time;
            this.EndTime = SpyTime.InvalidValue;
            this.LeftX = this.BeginTime.GetMicroSeconds();
            this.Value = model.Value;
            this.Color = model.Color;
        }

        public SpyTime BeginTime { get; }

        public SpyTime EndTime { get; private set; }

        public bool IsClosed
        {
            get { return !double.IsNaN(this.RightX); }
        }

        public string Value { get; }

        public Color Color { get; }

        public double LeftX { get; }

        public double RightX
        {
            get { return _rightX; }
            private set { this.SetPropertyValue(ref _rightX, value); }
        }

        public override string ToString()
        {
            return this.Value;
        }

        public void SetEndTime(SpyTime endTime)
        {
            this.EndTime = endTime;
            this.SetRightX(endTime);
        }

        private void SetRightX(SpyTime endTime)
        {
            if (!endTime.Timestamp.IsValid)
            {
                this.RightX = double.NaN;
            }
            else
            {
                this.RightX = this.EndTime.Timestamp.MicroSeconds;
            }
        }
    }
}
