﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    internal class PlotPanelViewModelMock : PlotPanelViewModel
    {
        public PlotPanelViewModelMock()
        {
            this.Nodes.Add(
                new PlotNodeData(name: string.Empty)
                {
                    IsChecked = true,
                    IsGlobal = true,
                    Floats =
                    {
                        new PlotFloatData(
                            new PlotSpyModel.PlotFloat(
                                name: "Float 1",
                                fullName: "Float 1",
                                minimum: 0,
                                maximum: 1,
                                color: Colors.Yellow,
                                interpolation: PlotSpyModel.PlotFloatInterpolationMode.None,
                                parent: null,
                                attachTime: SpyTime.Zero)
                            {
                                Values =
                                {
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("0,0,0")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("100000,100,10")),
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("200000,200,20")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("300000,300,30")),
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("400000,400,40")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("500000,500,50")),
                                },
                            }),
                        new PlotFloatData(
                            new PlotSpyModel.PlotFloat(
                                name: "Float 2",
                                fullName: "Float 2",
                                minimum: 0,
                                maximum: 1,
                                color: Colors.Red,
                                interpolation: PlotSpyModel.PlotFloatInterpolationMode.None,
                                parent: null,
                                attachTime: SpyTime.Zero))
                        {
                            IsVisible = false,
                        },
                    },
                    States =
                    {
                        new PlotStateData(
                            new PlotSpyModel.PlotState(
                                name: "State 1",
                                fullName: "State 1",
                                color: Colors.Green,
                                parent: null,
                                attachTime: SpyTime.Zero)
                            {
                                Values =
                                {
                                    new PlotSpyModel.PlotStateValue(
                                        value: "A",
                                        color: Colors.Green,
                                        time: SpyTime.Parse("120000,0,0")),
                                    new PlotSpyModel.PlotStateValue(
                                        value: "B",
                                        color: Colors.Green,
                                        time: SpyTime.Parse("250000,0,0")),
                                    new PlotSpyModel.PlotStateValue(
                                        value: "C",
                                        color: Colors.Blue,
                                        time: SpyTime.Parse("350000,0,0")),
                                },
                            }),
                        new PlotStateData(
                            new PlotSpyModel.PlotState(
                                name: "State 2",
                                fullName: "State 2",
                                color: Colors.Green,
                                parent: null,
                                attachTime: SpyTime.Zero)
                            {
                                Values =
                                {
                                    new PlotSpyModel.PlotStateValue(
                                        value: "A",
                                        color: Colors.Yellow,
                                        time: SpyTime.Parse("250000,0,0")),
                                    new PlotSpyModel.PlotStateValue(
                                        value: "B",
                                        color: Colors.Red,
                                        time: SpyTime.Parse("300000,0,0")),
                                    new PlotSpyModel.PlotStateValue(
                                        value: "C",
                                        color: Colors.Red,
                                        time: SpyTime.Parse("350000,0,0")),
                                    new PlotSpyModel.PlotStateValue(
                                        value: "D",
                                        color: Colors.Yellow,
                                        time: SpyTime.Parse("354000,0,0")),
                                },
                            })
                        {
                            IsVisible = true,
                        },
                    },
                });

            this.Nodes.Add(
                new PlotNodeData(name: "Node 1")
                {
                    IsChecked = true,
                });

            this.Nodes.Add(
                new PlotNodeData(name: "Node 2")
                {
                    IsChecked = false,
                });

            this.Nodes.Add(
                new PlotNodeData(name: "Node 3")
                {
                    IsChecked = true,
                    Floats =
                    {
                        new PlotFloatData(
                            new PlotSpyModel.PlotFloat(
                                name: "Float 1",
                                fullName: PlotSpyModel.CreateFullName("Node 3", "Float 1"),
                                minimum: 0,
                                maximum: 1,
                                color: Colors.Yellow,
                                interpolation: PlotSpyModel.PlotFloatInterpolationMode.None,
                                parent: null,
                                attachTime: SpyTime.Zero)
                            {
                                Values =
                                {
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("0,0,0")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("100000,100,10")),
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("200000,200,20")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("300000,300,30")),
                                    new PlotSpyModel.PlotFloatValue(0, SpyTime.Parse("400000,400,40")),
                                    new PlotSpyModel.PlotFloatValue(1, SpyTime.Parse("500000,500,50")),
                                },
                            }),
                    },
                });

            this.Markers.Add(
                new MarkerViewModel()
                {
                    Description = "Marker 1",
                    ID = 1,
                    IsVisible = true,
                    Position = 200000,
                    Color = Colors.Red,
                });

            this.Markers.Add(
                new MarkerViewModel()
                {
                    Description = "Marker 2",
                    ID = 2,
                    IsVisible = true,
                    Position = 300000,
                    Color = Colors.Green,
                });

            this.Markers.Add(
                new MarkerViewModel()
                {
                    Description = "Marker 3",
                    ID = 3,
                    IsVisible = true,
                    Position = 400000,
                    Color = Colors.Blue,
                });

            var frames = new[]
            {
                SpyTime.Parse("0,0,0"),
                SpyTime.Parse("100000,100,10"),
                SpyTime.Parse("200000,200,20"),
                SpyTime.Parse("300000,300,30"),
                SpyTime.Parse("400000,400,40"),
                SpyTime.Parse("500000,500,50"),
                SpyTime.Parse("500000,500,50"),
            };

            this.FrameSyncModel = new FrameSyncSpyModel();
            foreach (var f in frames)
            {
                this.FrameSyncModel.AllFrames.Add(f);
                this.FrameSyncModel.AppFrames.Add(f);
                this.FrameSyncModel.AudioFrames.Add(f);
            }

            // NOTE: アイテムに値が伝搬するように、プロパティの設定を最後に行います。
            this.CurrentFrame = 250000;
            this.MaximumFrame = 500000;
            this.MinimumFrame = 0;
            this.ScaleX = 0.001;
            this.TimeUnit = SpyTimeUnit.Timestamp;
            this.ViewportLeft = 100000;
        }
    }
}
