﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace NintendoWare.Spy.Windows
{
    public class NumericTextBoxBehavior : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            base.OnAttached();

            this.AssociatedObject.PreviewTextInput += OnPreviewTextInput;
            DataObject.AddPastingHandler(this.AssociatedObject, OnPasting);
        }

        protected override void OnDetaching()
        {
            this.AssociatedObject.PreviewTextInput -= OnPreviewTextInput;
            DataObject.RemovePastingHandler(this.AssociatedObject, OnPasting);

            base.OnDetaching();
        }

        private void OnPreviewTextInput(object sender, TextCompositionEventArgs e)
        {
            if (Validate(e.Text) == false)
            {
                e.Handled = true;
            }
        }

        private void OnPasting(object sender, DataObjectPastingEventArgs e)
        {
            var textBox = sender as TextBox;
            if (textBox == null)
            {
                return;
            }

            DataObject dataObject = e.DataObject as DataObject;
            string text = dataObject.GetText();
            if (Validate(text) == false)
            {
                e.CancelCommand();
                e.Handled = true;
            }
        }

        private bool Validate(string text)
        {
            Regex regex = new Regex("^[-]?[0-9]?$");
            return regex.IsMatch(text);
        }
    }
}
