﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.ObjectModel;
using System.Linq;

namespace NintendoWare.Spy.Windows
{
    public class MeterPanelViewModel : DisposableObject
    {
        private readonly ObservableCollection<MeterControlViewModel> _collection = new ObservableCollection<MeterControlViewModel>();

        public MeterPanelViewModel()
        {
        }

        protected override void DisposeManagedInstance()
        {
            _collection.ForEach(it => it.Dispose());

            base.DisposeManagedInstance();
        }

        public ObservableCollection<MeterControlViewModel> MeterCollection
        {
            get
            {
                return _collection;
            }
        }
    }
}
