﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Plugins;
using System.Linq;
using System.Windows.Controls;

namespace NintendoWare.Spy.Windows
{
    internal class MeterPanelPresenter : SpyPanelPresenter
    {
        private MeterPanel _view;
        private MeterPanelViewModel _viewModel;

        protected override void OnUninitialize()
        {
            Disposer.SafeDispose(ref _viewModel);

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            _viewModel = new MeterPanelViewModel();
            _view = new MeterPanel()
            {
                DataContext = _viewModel,
            };

            MeterControlViewModel meterViewModel = new MeterControlViewModel(this.GetSpyService(), this.GetPlaybackService());
            meterViewModel.Title = "nn::audio";
            meterViewModel.DisplayMaxPerformanceValue = 5000 * 1.5; // とりあえず値
            _viewModel.MeterCollection.Add(meterViewModel);

            return _view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case PlotSpyModelPlugin.SpyDataName:
                    _viewModel.MeterCollection.ForEach(vm => vm.SetPlotModel((PlotSpyModel)model));
                    break;
            }
        }
    }
}
