﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Windows;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    public class MeterControlItemViewModel : ObservableObject
    {
        private double _left;
        private double _right;
        private Brush _fill;
        private string _label;
        private Visibility _visibility;
        private double _value;

        public MeterControlItemViewModel()
        {
        }

        public double Left
        {
            get
            {
                return _left;
            }
            set
            {
                this.SetPropertyValue(ref _left, value);
            }
        }

        public double Right
        {
            get
            {
                return _right;
            }
            set
            {
                this.SetPropertyValue(ref _right, value);
            }
        }

        public Brush Fill
        {
            get
            {
                return _fill;
            }
            set
            {
                this.SetPropertyValue(ref _fill, value);
            }
        }

        public Visibility Visibility
        {
            get
            {
                return _visibility;
            }
            set
            {
                this.SetPropertyValue(ref _visibility, value);
            }
        }

        public string Label
        {
            get
            {
                return _label;
            }
            set
            {
                this.SetPropertyValue(ref _label, value);
            }
        }

        public double Value
        {
            get
            {
                return _value;
            }
            set
            {
                this.SetPropertyValue(ref _value, value);
            }
        }
    }
}
