﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.ToolFoundation.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// マーカーのビューモデルです。
    /// </summary>
    public class MarkerViewModel : ObservableObject, ILineChartMarkerData
    {
        private ulong _id;
        private bool _isVisible = true;
        private Color _color;
        private SpyTime _time;
        private string _description;
        private double _position;

        /// <summary>
        /// モックアップ用のコンストラクタです。
        /// </summary>
        internal MarkerViewModel()
        {
        }

        public MarkerViewModel(MarkerSpyModel.MarkerValue model)
        {
            Ensure.Argument.NotNull(model);
            Ensure.Argument.NotNull(model.Owner);

            this.ID = model.Owner.ID;
            this.Color = model.Color;
            this.Time = new SpyTime(model.Timestamp, model.BelongingFrame);
            this.Description = model.Description;
            this.Position = this.Time.GetMicroSeconds();
        }

        public ulong ID
        {
            get { return _id; }
            set { this.SetPropertyValue(ref _id, value); }
        }

        public bool IsVisible
        {
            get { return _isVisible; }
            set { this.SetPropertyValue(ref _isVisible, value); }
        }

        public Color Color
        {
            get { return _color; }
            set { this.SetPropertyValue(ref _color, value); }
        }

        public SpyTime Time
        {
            get { return _time; }
            set { this.SetPropertyValue(ref _time, value); }
        }

        public string Description
        {
            get { return _description; }
            set { this.SetPropertyValue(ref _description, value); }
        }

        public double Position
        {
            get { return _position; }
            set { this.SetPropertyValue(ref _position, value); }
        }

        string ILineChartMarkerData.Name
        {
            get { return this.Description; }
        }

        double ILineChartMarkerData.Position
        {
            get { return this.Position; }
        }
    }
}
