﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.ToolFoundation.Windows.Input;
using NintendoWare.Spy.Plugins;
using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// パネルを制御する ViewModel です。
    /// </summary>
    public sealed class SpyPanelViewModel : ObservableObject
    {
        private readonly SpyPanelPlugin _panelPlugin;
        private readonly Func<SpyPanelPlugin, Control> _createPanelContent;
        private readonly Lazy<Control> _content;
        private readonly Lazy<Control> _errorContent = new Lazy<Control>(CreateErrorContent);

        private bool _isSelected = false;
        private bool _isVisible = false;

        //-----------------------------------------------------------------

        public SpyPanelViewModel(SpyPanelPlugin panelPlugin, Func<SpyPanelPlugin, Control> createPanelContent)
        {
            Ensure.Argument.NotNull(panelPlugin);
            Ensure.Argument.NotNull(createPanelContent);

            _panelPlugin = panelPlugin;
            _createPanelContent = createPanelContent;
            _content = new Lazy<Control>(() => _createPanelContent(_panelPlugin));

            this.CloseCommand = new DelegateCommand(param =>
                {
                    this.IsVisible = false;
                });
        }

        //-----------------------------------------------------------------

        public string PanelID
        {
            get { return _panelPlugin.PanelID; }
        }

        public string PanelTitle
        {
            get { return _panelPlugin.PanelTitle; }
        }

        /// <summary>
        /// 必要な Spy データ名の列挙子を取得します。
        /// </summary>
        public IEnumerable<string> RequiredSpyDataNames
        {
            get { return _panelPlugin.RequiredSpyDataNames; }
        }

        /// <summary>
        /// サポートするプラットフォームの列挙子を取得します。
        /// </summary>
        public IEnumerable<string> SupportedPlatforms
        {
            get { return _panelPlugin.SupportedPlatforms; }
        }

        public bool IsSelected
        {
            get { return _isSelected; }
            set { this.SetPropertyValue(ref _isSelected, value); }
        }

        public bool IsVisible
        {
            get { return _isVisible; }
            set { this.SetPropertyValue(ref _isVisible, value); }
        }

        public ICommand CloseCommand
        {
            get;
            private set;
        }

        public Control Content
        {
            get
            {
                try
                {
                    return _content.Value;
                }
                catch
                {
                    return _errorContent.Value;
                }
            }
        }

        //-----------------------------------------------------------------

        private static Control CreateErrorContent()
        {
            var result = new ContentControl()
            {
                Background = Brushes.WhiteSmoke,
                BorderBrush = Brushes.OrangeRed,
                BorderThickness = new Thickness(1),
            };

            result.Content = new TextBlock()
            {
                Text = "Panel Initialization Error!!",
                Foreground = Brushes.OrangeRed,
                HorizontalAlignment = HorizontalAlignment.Center,
                VerticalAlignment = VerticalAlignment.Center,
            };

            return result;
        }
    }
}
