﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Windows.Controls;
using Xceed.Wpf.AvalonDock.Layout;

namespace NintendoWare.Spy.Windows
{
    internal class LayoutUpdateStrategy : ILayoutUpdateStrategy
    {
        public bool BeforeInsertAnchorable(LayoutRoot layout, LayoutAnchorable anchorableToShow, ILayoutContainer destinationContainer)
        {
            // デフォルトのレイアウト戦略を利用します。
            return false;
        }

        public void AfterInsertAnchorable(LayoutRoot layout, LayoutAnchorable anchorableShown)
        {
            // AvalonDock がパネルを配置する適切な場所を決められなかったときは、
            // 適当な場所に配置します。

            if (anchorableShown.Parent != layout)
            {
                // 正常に配置が出来ていたら何もしません。
                return;
            }

            var container = layout.Descendents()
                .OfType<LayoutAnchorablePane>()
                .FirstOrDefault();

            if (container != null)
            {
                // LayoutAnchorablePane があれば、そこに追加します。
                container.Children.Add(anchorableShown);
            }
            else
            {
                // 現在のレイアウトの隣に、新しいパネルを追加します。
                container = new LayoutAnchorablePane();

                container.Children.Add(anchorableShown);

                var layoutPanel = new LayoutPanel()
                {
                    Orientation = Orientation.Horizontal,
                };

                if (layout.RootPanel != null)
                {
                    layoutPanel.Children.Add(layout.RootPanel);
                }

                layout.RootPanel = layoutPanel;

                layoutPanel.Children.Add(container);
            }
        }

        public bool BeforeInsertDocument(LayoutRoot layout, LayoutDocument anchorableToShow, ILayoutContainer destinationContainer)
        {
            throw new NotImplementedException();
        }

        public void AfterInsertDocument(LayoutRoot layout, LayoutDocument anchorableShown)
        {
            throw new NotImplementedException();
        }
    }
}
