﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Windows.Input;
using System;
using System.Windows.Input;

namespace NintendoWare.Spy.Windows
{
    public sealed class ConnectionInfoViewModel : ObservableObject
    {
        private readonly ConnectionInfo _connectionInfo;
        private bool _isConnected = false;
        private string _largeImageUri = string.Empty;
        private string _largeDisconnectedImageUri = string.Empty;

        //-----------------------------------------------------------------

        public ConnectionInfoViewModel(
            ConnectionInfo connectionInfo,
            string smallImageUri,
            string largeImageUri,
            string text,
            Action<ConnectionInfoViewModel> selectAction)
        {
            _connectionInfo = connectionInfo;
            this.Text = text;
            this.SmallImageUri = smallImageUri;
            _largeImageUri = largeImageUri;
            this.SelectCommand = new DelegateCommand(sender => selectAction(this));
        }

        //-----------------------------------------------------------------

        public ConnectionInfo ConnectionInfo => _connectionInfo;

        public string TargetPlatformName => _connectionInfo.TargetPlatformName;

        public bool IsForNintendoSDK => _connectionInfo.IsForNintendoSDK;

        public string Text { get; private set; }

        public string SmallImageUri { get; private set; }

        public string LargeImageUri
        {
            get { return _largeImageUri; }
        }

        public bool IsConnected
        {
            get { return _isConnected; }

            set
            {
                if (_isConnected == value)
                {
                    return;
                }

                _isConnected = value;
                this.NotifyPropertyChanged();
                this.NotifyPropertyChanged(() => this.LargeImageUri);
            }
        }

        public ICommand SelectCommand { get; private set; }
    }
}
