﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy.Foundation.Communications;
using System.Collections.Generic;
using System.ComponentModel.Composition.Hosting;
using System.Reflection;

namespace NintendoWare.Spy.Plugins
{
    public class PluginsService : ObservableObject
    {
        private CompositionContainer _pluginContainer;
        private bool _isInitialized = false;

        private IEnumerable<HostIOPlugin> _hostIOPlugins;
        private IEnumerable<SpyConnectionPlugin> _connectionPlugins;
        private IEnumerable<SpyModelPlugin> _modelPlugins;
        private IEnumerable<SpyPanelPlugin> _panelPlugins;
        private IEnumerable<SpyRibbonTabPlugin> _ribbonTabPlugins;

        //-----------------------------------------------------------------

        public bool IsInitialized
        {
            get { return _isInitialized; }
            set { this.SetPropertyValue(ref _isInitialized, value); }
        }

        public IEnumerable<HostIOPlugin> HostIOPlugins
        {
            get { return _hostIOPlugins; }
            private set { this.SetPropertyValue(ref _hostIOPlugins, value); }
        }

        public IEnumerable<SpyConnectionPlugin> ConnectionPlugins
        {
            get { return _connectionPlugins; }
            private set { this.SetPropertyValue(ref _connectionPlugins, value); }
        }

        public IEnumerable<SpyModelPlugin> ModelPlugins
        {
            get { return _modelPlugins; }
            private set { this.SetPropertyValue(ref _modelPlugins, value); }
        }

        public IEnumerable<SpyPanelPlugin> PanelPlugins
        {
            get { return _panelPlugins; }
            private set { this.SetPropertyValue(ref _panelPlugins, value); }
        }

        public IEnumerable<SpyRibbonTabPlugin> RibbonTabPlugins
        {
            get { return _ribbonTabPlugins; }
            private set { this.SetPropertyValue(ref _ribbonTabPlugins, value); }
        }

        //-----------------------------------------------------------------

        public void Initialize(IEnumerable<Assembly> assemblies)
        {
            try
            {
                var catalog = new AggregateCatalog();

                foreach (var assembly in assemblies)
                {
                    catalog.Catalogs.Add(new AssemblyCatalog(assembly));
                }

                _pluginContainer = new CompositionContainer(catalog);

                this.HostIOPlugins = _pluginContainer.GetExportedValues<HostIOPlugin>();
                this.ConnectionPlugins = _pluginContainer.GetExportedValues<SpyConnectionPlugin>();
                this.ModelPlugins = _pluginContainer.GetExportedValues<SpyModelPlugin>();
                this.PanelPlugins = _pluginContainer.GetExportedValues<SpyPanelPlugin>();
                this.RibbonTabPlugins = _pluginContainer.GetExportedValues<SpyRibbonTabPlugin>();

                this.IsInitialized = true;
            }
            catch
            {
                this.Uninitialize();
            }
        }

        public void Uninitialize()
        {
            this.HostIOPlugins = null;
            this.ConnectionPlugins = null;
            this.ModelPlugins = null;
            this.PanelPlugins = null;
            this.RibbonTabPlugins = null;
            this.IsInitialized = false;
            Disposer.SafeDispose(ref _pluginContainer);
        }

        protected override void OnDisposed(System.EventArgs e)
        {
            this.Uninitialize();

            base.OnDisposed(e);
        }
    }
}
