﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation.Commands;

namespace NintendoWare.Spy.Commands
{
    public static class AudioSaveRecordWaveDataDialogCommandHandler
    {
        public static CommandStatus CanExecute(AudioSaveRecordWaveDataDialogCommandArgs commandArgs)
        {
            if (commandArgs == null)
            {
                return CommandStatus.Unsupported;
            }

            if (commandArgs.SpyService == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyService.IsLoading)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyPlaybackService == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyPlaybackService.FinalOutModel == null &&
                commandArgs.SpyPlaybackService.WaveformModel == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.WaveSourceOutputInfo == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.ConnectionSettings == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.ConnectionSettings.IsConnecting)
            {
                return CommandStatus.Disabled;
            }

            return CommandStatus.Enabled;
        }

        public static CommandResult Execute(AudioSaveRecordWaveDataDialogCommandArgs commandArgs)
        {
            if (string.IsNullOrEmpty(commandArgs.SaveFileDialogCommandArgs.Title))
            {
                commandArgs.SaveFileDialogCommandArgs.Title = Resources.Labels.SaveRecordWaveDataDialogTitle;
            }

            if (string.IsNullOrEmpty(commandArgs.SaveFileDialogCommandArgs.Filter))
            {
                commandArgs.SaveFileDialogCommandArgs.Filter = "*.wav|*.*";
            }

            if (string.IsNullOrEmpty(commandArgs.SaveFileDialogCommandArgs.DefaultExtension))
            {
                commandArgs.SaveFileDialogCommandArgs.DefaultExtension = "wav";
            }

            if (string.IsNullOrEmpty(commandArgs.SaveFileDialogCommandArgs.FileName))
            {
                commandArgs.SaveFileDialogCommandArgs.FileName = "Output";
            }

            var result = SaveFileDialogCommandHandler.Execute(commandArgs.SaveFileDialogCommandArgs);

            if (result == null || result.Length != 1)
            {
                return CommandResult.CreateCanceled();
            }

            commandArgs.OutputFilePath = result[0];

            return AudioSaveRecordWaveDataHandler.Execute(commandArgs);
        }
    }
}
