﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// すべて記録コマンドの引数。
    /// </summary>
    public sealed class RecordAllFilesCommandArgs : SpyServiceCommandArgs, IDeepClonable
    {
        public string OutputDirectoryPath { get; set; }
        public bool IsConnecting { get; set; }

        public RecordAllFilesCommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            return this.DeepCloneTo(new RecordAllFilesCommandArgs());
        }

        private object DeepCloneTo(RecordAllFilesCommandArgs toArgs)
        {
            base.DeepCloneTo(toArgs);

            toArgs.OutputDirectoryPath = this.OutputDirectoryPath;
            toArgs.IsConnecting = this.IsConnecting;

            return toArgs;
        }
    }
}
