﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Foundation.Commands;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// Spy ターゲットから切断コマンドのハンドラです。
    /// </summary>
    internal static class SpyDisconnectHandler
    {
        public static CommandStatus CanExecute(SpyServiceCommandArgs commandArgs)
        {
            if (commandArgs == null)
            {
                return CommandStatus.Unsupported;
            }

            if (commandArgs.SpyService == null)
            {
                return CommandStatus.Disabled;
            }

            switch (commandArgs.SpyService.State)
            {
                case SpyService.ServiceState.Starting:
                case SpyService.ServiceState.Running:
                    return CommandStatus.Enabled;
            }

            return CommandStatus.Disabled;
        }

        public static CommandResult Execute(SpyServiceCommandArgs commandArgs)
        {
            Ensure.Operation.True(CanExecute(commandArgs).IsEnabled());

            try
            {
                commandArgs.SpyService.Stop();
            }
            catch
            {
            }

            return CommandResult.CreateSucceeded();
        }
    }
}
