﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Foundation.Commands;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// Spy ターゲットに接続コマンドのハンドラです。
    /// </summary>
    internal static class SpyConnectHandler
    {
        public static CommandStatus CanExecute(ConnectCommandArgs commandArgs)
        {
            if (commandArgs == null)
            {
                return CommandStatus.Unsupported;
            }

            if (commandArgs.SpyService == null ||
                string.IsNullOrEmpty(commandArgs.TargetPlatformName) ||
                commandArgs.SyncPort == null ||
                commandArgs.DataPort == null)
            {
                return CommandStatus.Disabled;
            }

            if (commandArgs.SpyService.State != SpyService.ServiceState.NotStarted)
            {
                return CommandStatus.Disabled;
            }

            return CommandStatus.Enabled;
        }

        public static CommandResult Execute(ConnectCommandArgs commandArgs)
        {
            Ensure.Operation.True(CanExecute(commandArgs).IsEnabled());

            try
            {
                commandArgs.SpyService.Start(
                    commandArgs.TargetPlatformName,
                    commandArgs.SyncPort,
                    commandArgs.DataPort);
            }
            catch
            {
            }

            return CommandResult.CreateSucceeded();
        }
    }
}
