﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// ターゲットに接続コマンドの引数。
    /// </summary>
    public sealed class ConnectCommandArgs : SpyServiceCommandArgs, IDeepClonable
    {
        public string TargetPlatformName { get; set; }

        public object SyncPort { get; set; }

        public object DataPort { get; set; }

        public ConnectCommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            return this.DeepCloneTo(new ConnectCommandArgs());
        }

        private object DeepCloneTo(ConnectCommandArgs to)
        {
            base.DeepCloneTo(to);

            to.TargetPlatformName = this.TargetPlatformName;
            to.SyncPort = this.SyncPort;
            to.DataPort = this.DataPort;

            return to;
        }
    }
}
