﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation.Commands;
using NintendoWare.Spy.Resources;

namespace NintendoWare.Spy.Commands
{
    public class SpyAudioCommands
    {
        /// <summary>
        /// 録音波形の保存 コマンド。
        /// </summary>
        public static readonly Command SaveRecordWaveData = new Command(
            "SpyAudio.SaveRecordData",
            CommandLabels.SpyAudioSaveReocrdWaveData,
            null,
            typeof(AudioSaveRecordWaveDataCommandArgs));

        /// <summary>
        /// 録音波形の保存（ダイアログ） コマンド。
        /// </summary>
        public static readonly Command SaveRecordWaveDataDialog = new Command(
            "SpyAudio.SaveRecordDataDialog",
            CommandLabels.SpyAudioSaveReocrdWaveDataDialog,
            null,
            typeof(AudioSaveRecordWaveDataCommandArgs));
    }
}
