﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    public class PlayingSoundItemViewModel : ObservableObject
    {
        public enum PlayKinds
        {
            Loop,
            Oneshot,
        }

        /// <summary>
        /// ステートタイプ
        /// </summary>
        public enum StateType
        {
            Preapre = 0,
            Playing,
            Pause,
            None,
        }

        private string _assetName = string.Empty;
        private string _groupName = string.Empty;
        private float _volume;

        private float _priority;
        private PlayKinds _playKind;
        private StateType _state;

        private bool _isAlive;
        private bool _isFiltered;
        private bool _isVisible;
        private bool _isAudible;

        ///
        public PlayingSoundItemViewModel()
        {
        }

        public uint InstanceID { get; set; }

        public uint SoundID { get; set; }

        ///
        public bool IsAlive
        {
            get
            {
                return _isAlive;
            }
            set
            {
                this.SetPropertyValue(ref _isAlive, value);
                this.UpdateVisible();
            }
        }

        public bool IsFiltered
        {
            get
            {
                return _isFiltered;
            }
            set
            {
                this.SetPropertyValue(ref _isFiltered, value);
                this.UpdateVisible();
            }
        }

        public bool IsVisible
        {
            get
            {
                return _isVisible;
            }
            private set
            {
                this.SetPropertyValue(ref _isVisible, value);
            }
        }

        public StateType State
        {
            get
            {
                return _state;
            }
            set
            {
                this.SetPropertyValue(ref _state, value);
            }
        }

        public bool IsAudible
        {
            get
            {
                return _isAudible;
            }
            set
            {
                this.SetPropertyValue(ref _isAudible, value);
            }
        }

        public string SoundName
        {
            get
            {
                return _assetName;
            }
            set
            {
                this.SetPropertyValue(ref _assetName, value);
            }
        }

        public string PlayerName
        {
            get
            {
                return _groupName;
            }
            set
            {
                this.SetPropertyValue(ref _groupName, value);
            }
        }

        public float Volume
        {
            get
            {
                return _volume;
            }
            set
            {
                this.SetPropertyValue(ref _volume, value);
                this.UpdateAudible();
            }
        }

        public float Priority
        {
            get
            {
                return _priority;
            }
            set
            {
                this.SetPropertyValue(ref _priority, value);
            }
        }

        public PlayKinds PlayKind
        {
            get
            {
                return _playKind;
            }
            set
            {
                this.SetPropertyValue(ref _playKind, value);
            }
        }

        ///
        public void CopyFrom(PlayingSoundItemViewModel src)
        {
            this.InstanceID = src.InstanceID;

            this.IsAlive = src.IsAlive;
            this.IsFiltered = src.IsFiltered;
            this.IsVisible = src.IsVisible;
            this.IsAudible = src.IsAudible;
            this.State = src.State;
            this.SoundName = src.SoundName;
            this.PlayerName = src.PlayerName;
            this.Volume = src.Volume;
            this.Priority = src.Priority;
            this.PlayKind = src.PlayKind;
        }

        ///
        private void UpdateVisible()
        {
            this.IsVisible = _isAlive && _isFiltered;
        }

        ///
        private void UpdateAudible()
        {
            this.IsAudible = Math.Abs(this.Volume) < float.Epsilon ? false : true;
        }
    }
}
