﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy.Settings;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    public sealed class NwSoundSettingsViewModel : ObservableObject
    {
        private WaveVisibility _finalOutTvWaveVisibility = WaveVisibility.None;
        private WaveVisibility _finalOutDrcWaveVisibility = WaveVisibility.None;
        private WaveVisibility _loudnessTvWaveVisibility = WaveVisibility.None;
        private WaveVisibility _loudnessDrcWaveVisibility = WaveVisibility.None;

        public WaveVisibility FinalOutTvWaveVisibility
        {
            get { return _finalOutTvWaveVisibility; }
            set { this.SetPropertyValue(ref _finalOutTvWaveVisibility, value); }
        }

        public WaveVisibility FinalOutDrcWaveVisibility
        {
            get { return _finalOutDrcWaveVisibility; }
            set { this.SetPropertyValue(ref _finalOutDrcWaveVisibility, value); }
        }

        public WaveVisibility LoudnessTvWaveVisibility
        {
            get { return _loudnessTvWaveVisibility; }
            set { this.SetPropertyValue(ref _loudnessTvWaveVisibility, value); }
        }

        public WaveVisibility LoudnessDrcWaveVisibility
        {
            get { return _loudnessDrcWaveVisibility; }
            set { this.SetPropertyValue(ref _loudnessDrcWaveVisibility, value); }
        }
    }
}
