﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    internal class PeakHold
    {
        public event EventHandler ValueChangedEvent;

        public int Hold { get; set; } = 100;
        public int Release
        {
            get { return _releaseValue; }
            set
            {
                _releaseValue = value;
                _releaseRatio = Math.Pow(2, -value / 200.0);
            }
        }
        public float PeakValue
        {
            get { return _peakValue; }
            set { _peakValue = value; }
        }

        private float _peakValue;
        private int _holdCounter;
        private int _releaseValue = 1000;
        private double _releaseRatio;
        private readonly Timer _timer = new Timer();
        private float _currentValue;

        public PeakHold()
        {
            _peakValue = float.NegativeInfinity;
            _holdCounter = 0;
            _releaseRatio = Math.Pow(2, -_releaseValue / 200.0);

            _timer.Interval = 10;
            _timer.Tick += new EventHandler(TimerOnTick);
        }

        public void Update(float currentValue)
        {
            float prevValue = _peakValue;

            if (currentValue >= _peakValue)
            {
                _timer.Enabled = false;

                _peakValue = currentValue;
                _holdCounter = 0;
            }
            else
            {
                _currentValue = currentValue;
                _timer.Enabled = true;
            }

            if (ValueChangedEvent != null && prevValue != _peakValue)
            {
                ValueChangedEvent(this, EventArgs.Empty);
            }
        }

        private void TimerOnTick(object obj, EventArgs ea)
        {
            float prevValue = _peakValue;

            if (_holdCounter < Hold)
            {
                _holdCounter++;
            }
            else
            {
                _peakValue = (float)(_currentValue * _releaseRatio) + (float)(_peakValue * (1 - _releaseRatio));
                if (_currentValue >= _peakValue)
                {
                    _peakValue = _currentValue;
                    _holdCounter = 0;
                }
            }

            if (ValueChangedEvent != null && prevValue != _peakValue)
            {
                ValueChangedEvent(this, EventArgs.Empty);
            }
        }
    }
}
