﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.NwSoundSpyPlugin.Models;
using NintendoWare.Spy;
using NintendoWare.Spy.Plugins;

namespace NintendoWare.NwSoundSpyPlugin.Plugins
{
    /// <summary>
    /// サウンド状態のモデルプラグインです。
    /// </summary>
    public sealed class SoundStatusInfoSpyModelPlugin : SpyModelPlugin
    {
        /// <summary>
        /// サウンド状態のデータ名です。
        /// </summary>
        public const string SpyDataName = "NwSoundStatusInfo";

        //-----------------------------------------------------------------

        /// <summary>
        /// データ名を取得します。
        /// </summary>
        public override string DataName
        {
            get { return SpyDataName; }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// モジュールを生成します。
        /// </summary>
        /// <returns>生成したモジュールを返します。</returns>
        public override SpyModel CreateSpyModel()
        {
            return new SoundStatusInfoSpyModel();
        }
    }
}
