﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy;
using System.Linq;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class SequenceVariableItemViewModel : ObservableObject
    {
        private bool _isAlive = false;
        private bool _isVisible = false;
        private int[] _values = null;
        private string[] _displayValues = null;

        public SequenceVariableItemViewModel()
        { }

        public uint SoundId { get; set; }

        public uint SoundInstanceId { get; set; }

        public ulong ArchiveInstanceId { get; set; }

        public bool IsVariableAvailable { get; set; }

        public uint VariableId { get; set; }

        public SpyTime Time { get; set; }

        public bool IsAlive
        {
            get { return _isAlive; }
            set
            {
                if (this.SetPropertyValue(ref _isAlive, value) == true)
                {
                    this.UpdateVisible();
                }
            }
        }
        public bool IsVisible
        {
            get { return _isVisible; }
            private set { this.SetPropertyValue(ref _isVisible, value); }
        }

        public string Name { get; set; }

        public int[] Variables
        {
            get { return _values; }
            set { this.SetPropertyValue(ref _values, value); }
        }

        public string[] DisplayVariables
        {
            get { return _displayValues; }
            private set { this.SetPropertyValue(ref _displayValues, value); }
        }

        private void UpdateVisible()
        {
            this.IsVisible = _isAlive;
        }

        public void CopyFrom(SequenceVariableItemViewModel src)
        {
            this.SoundId = src.SoundId;
            this.SoundInstanceId = src.SoundInstanceId;
            this.ArchiveInstanceId = src.ArchiveInstanceId;
            this.VariableId = src.VariableId;
            this.IsVariableAvailable = src.IsVariableAvailable;
            this.Time = src.Time;

            this.IsAlive = src.IsAlive;
            this.IsVisible = src.IsVisible;
            this.Name = src.Name;

            this.Variables = (int[])src.Variables.Clone();

            if (this.IsVariableAvailable == true)
            {
                this.DisplayVariables = this.Variables
                    .Select(v => v.ToString())
                    .ToArray();
            }
            else
            {
                this.DisplayVariables = Enumerable.Repeat(string.Empty, this.Variables.Count())
                    .ToArray();
            }
        }
    }
}
