﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.NnAtkSpyPlugin.Plugins;
using NintendoWare.Spy;
using NintendoWare.Spy.Windows;
using System.Threading;
using System.Windows.Controls;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class PlayingSoundPanelPresenter : SpyPanelPresenter
    {
        private readonly PlayingSoundPanelViewModel _viewModel;
        private PlayingSoundPanel _view = null;
        private readonly object _observerOwner = new object();

        public PlayingSoundPanelPresenter()
        {
            _viewModel = new PlayingSoundPanelViewModel()
            {
                SyncContext = SynchronizationContext.Current,
            };
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            PropertyChangedObservation.GetObserver(_observerOwner, this.GetPlaybackService())
                .AddHandler(
                    target => target.Current,
                    (target, args) => UpdateGlobalCurrentPosition());

            this.UpdateGlobalCurrentPosition();
        }

        protected override void OnUninitialize()
        {
            PropertyChangedObservation.RemoveObservers(_observerOwner);

            _viewModel.Dispose();

            base.OnUninitialize();
        }

        protected override Control CreateContent()
        {
            _view = new PlayingSoundPanel()
            {
                DataContext = _viewModel
            };
            return _view;
        }

        protected override void UpdateSpyModel(string dataName, SpyModel model)
        {
            switch (dataName)
            {
                case AtkSpyModelPlugin.SpyDataName:
                    _viewModel.SetModel(model as AtkSpyModel);
                    break;
            }
        }

        ///
        private void UpdateGlobalCurrentPosition()
        {
            if (_view == null)
            {
                return;
            }

            var playbackService = this.GetPlaybackService();
            var current = playbackService.Current;
            _viewModel.CurrentTime = current;
        }
    }
}
