﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.Generic;
using System.Windows.Media;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    internal class LoudnessMeterLevelItemViewModel : ObservableObject
    {
        public static readonly Brush DefaultColor = Brushes.WhiteSmoke;
        public static readonly Color DefaultChartColor = Colors.WhiteSmoke;

        private string _name = string.Empty;
        private double _value = double.NaN;
        private bool _visible = true;
        private Brush _color = DefaultColor;
        private Color _chartColor = DefaultChartColor;
        private IEnumerable<LoudnessMeterThreshold> _thresholds;

        internal LoudnessMeterPanelViewModel Owner { get; set; }

        internal LoudnessMeterPanelViewModel.ValueSelectFunc ValueSelectFunc { get; set; }

        internal LoudnessMeterPanelViewModel.ValueSelectFunc PeakSelectFunc { get; set; }

        public string Name
        {
            get { return _name; }
            set { this.SetPropertyValue(ref _name, value); }
        }

        public double Value
        {
            get { return _value; }
            set { this.SetPropertyValue(ref _value, value); }
        }

        public double Maximum { get; set; } = LoudnessMeterPanelViewModel.DisplayRangeMaximumY;

        public double Minimum { get; set; } = LoudnessMeterPanelViewModel.DisplayRangeMinimumY;

        public bool IsVisible
        {
            get { return _visible; }
            set { this.SetPropertyValue(ref _visible, value); }
        }

        public Brush Color
        {
            get { return _color; }
            set { this.SetPropertyValue(ref _color, value); }
        }

        public Color ChartColor
        {
            get { return _chartColor; }
            set { this.SetPropertyValue(ref _chartColor, value); }
        }

        public IEnumerable<LoudnessMeterThreshold> Thresholds
        {
            get { return _thresholds; }
            set { this.SetPropertyValue(ref _thresholds, value); }
        }

        public LoudnessMeterLevelItemViewModel()
        {
        }
    }
}
