﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class LoudnessMeterGridItem : ContentControl
    {
        private static readonly Brush DefaultStroke = Brushes.Gray;

        public static readonly DependencyProperty StrokeProperty =
            DependencyProperty.Register(
                nameof(Stroke),
                typeof(Brush),
                typeof(LoudnessMeterGridItem),
                new FrameworkPropertyMetadata(
                    DefaultStroke,
                    null,
                    (d, e) => Self(d).CoerceStroke(e)));

        public Brush Stroke
        {
            get { return (Brush)this.GetValue(StrokeProperty); }
            set { this.SetValue(StrokeProperty, value); }
        }

        static LoudnessMeterGridItem()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(LoudnessMeterGridItem),
                new FrameworkPropertyMetadata(typeof(LoudnessMeterGridItem)));
        }

        private object CoerceStroke(object e)
        {
            if (e is Brush)
            {
                return e;
            }
            else
            {
                return DefaultStroke;
            }
        }

        private static LoudnessMeterGridItem Self(object obj)
        {
            return (LoudnessMeterGridItem)obj;
        }
    }
}
