﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Globalization;
using System.Windows;
using System.Windows.Data;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    /// <summary>
    /// int の値を BiquadFilter の文字列に変換します。
    /// </summary>
    [ValueConversion(typeof(int), typeof(string))]
    public sealed class IntegerToBiquadFilterStringConverter : IValueConverter
    {
        private static string[] BqfLabels =
        {
            Resources.Labels.Bqf_Inherit,
            Resources.Labels.Bqf_None,
            Resources.Labels.Bqf_LPF,
            Resources.Labels.Bqf_HPF,
            Resources.Labels.Bqf_BPF512,
            Resources.Labels.Bqf_BPF1024,
            Resources.Labels.Bqf_BPF2048,
        };

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is int)
            {
                var intValue = (int)value;
                if (intValue >= -1 && intValue < BqfLabels.Length - 1)
                {
                    return BqfLabels[intValue + 1];
                }
                else if (intValue >= 64 && intValue < 128)
                {
                    return string.Format(Resources.Labels.Bqf_User, intValue - 64);
                }
            }

            return DependencyProperty.UnsetValue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
