﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Interactivity;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public class GridViewColumnBehavior : Behavior<GridViewColumn>
    {
        protected override void OnAttached()
        {
            base.OnAttached();
            this.ApplyIsVisible();
        }

        protected override void OnDetaching()
        {
            base.OnDetaching();
            this.ApplyIsVisible(true);
        }

        public static GridViewColumnBehavior GetBehavior(GridViewColumn column)
        {
            foreach (var i in Interaction.GetBehaviors(column))
            {
                var behavior = i as GridViewColumnBehavior;
                if (behavior != null)
                {
                    return behavior;
                }
            }

            return null;
        }

        #region IsVisible

        public static readonly DependencyProperty IsVisibleProperty = DependencyProperty.Register(
            nameof(IsVisible),
            typeof(bool),
            typeof(GridViewColumnBehavior),
            new PropertyMetadata(true, (d, e) => ((GridViewColumnBehavior)d).ApplyIsVisible()));

        private double? _savedWidth;

        /// <summary>
        /// 列の表示を制御します。
        /// </summary>
        public bool IsVisible
        {
            get { return (bool)GetValue(IsVisibleProperty); }
            set { SetValue(IsVisibleProperty, value); }
        }

        private void ApplyIsVisible(bool detaching = false)
        {
            var column = this.AssociatedObject;

            if (column == null)
            {
                return;
            }

            if (detaching || this.IsVisible)
            {
                if (column.Width == 0)
                {
                    if (_savedWidth.HasValue)
                    {
                        column.Width = _savedWidth.Value;
                    }
                    else
                    {
                        column.Width = double.NaN;
                    }
                }
            }
            else
            {
                _savedWidth = column.Width;
                column.Width = 0;
            }
        }

        #endregion
        #region SortExpression

        public static readonly DependencyProperty SortExpressionProperty =
            DependencyProperty.Register(
            nameof(SortExpression),
            typeof(string),
            typeof(GridViewColumnBehavior));

        /// <summary>
        /// セルの値がソートに不適切な場合に、代わりに使うプロパティを指定します。
        /// </summary>
        public string SortExpression
        {
            get { return (string)GetValue(SortExpressionProperty); }
            set { SetValue(SortExpressionProperty, value); }
        }

        #endregion
    }
}
