﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    public interface IAtkPerformanceStateValue : INotifyPropertyChanged
    {
        double LeftX { get; }
        double RightX { get; }
    }

    public static class IAtkPerformanceStateValueExtension
    {
        public static double GetValidatedRightX(this IAtkPerformanceStateValue self)
        {
            var rightX = self.RightX;
            return double.IsNaN(rightX) ? self.LeftX : rightX;
        }
    }
}
