﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.CafeSpyPlugin.Communications;
using NintendoWare.CafeSpyPlugin.Foundation.Platform;
using NintendoWare.Spy.Plugins;
using NintendoWare.Spy.Settings;

namespace NintendoWare.CafeSpyPlugin.Plugins
{
    /// <summary>
    /// Win(NW4F) へのコネクションプラグインです。
    /// </summary>
    public sealed class CafeWinConnectionPlugin : SpyConnectionPlugin
    {
        /// <summary>
        /// 対象プラットフォーム名を取得します。
        /// </summary>
        public override string TargetPlatformName
        {
            get { return PlatformCafeWin.Name; }
        }

        /// <summary>
        /// NintendoSDK 対応のプラグインかどうかを示します。
        /// </summary>
        public override bool IsForNintendoSDK
        {
            get { return false; }
        }

        /// <summary>
        /// 小さいイメージの URI を取得します。
        /// </summary>
        public override string SmallImageUri
        {
            get { return "pack://application:,,,/CafeSpyPlugin;component/Resources/Images/WindowsSmall.png"; }
        }

        /// <summary>
        /// 大きいイメージの URI を取得します。
        /// </summary>
        public override string LargeImageUri
        {
            get { return "pack://application:,,,/CafeSpyPlugin;component/Resources/Images/WindowsLarge.png"; }
        }

        /// <summary>
        /// 大きい切断イメージの URI を取得します。
        /// </summary>
        public override string LargeDisconnectedImageUri
        {
            get { return "pack://application:,,,/CafeSpyPlugin;component/Resources/Images/WindowsLargeDisconnected.png"; }
        }

        /// <summary>
        /// UI に表示するテキストを取得します。
        /// </summary>
        public override string Text
        {
            get { return Resources.Labels.ConnectToWinForNw4f; }
        }

        /// <summary>
        /// Sync ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public override object GetSyncPort(ConnectionSettings connectionSettings)
        {
            return HostIOWinsock.SyncPort;
        }

        /// <summary>
        /// Data ポートの接続パラメータを取得します。
        /// </summary>
        /// <param name="connectionSettings"></param>
        /// <returns></returns>
        public override object GetDataPort(ConnectionSettings connectionSettings)
        {
            return HostIOWinsock.DataPort;
        }
    }
}
