﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.CafeSpyPlugin.Foundation.Communications
{
    /// <summary>
    /// Cafe の HostIO チャンネル情報を格納します。
    /// </summary>
    public class HostIOCafeChannelInfo
    {
        private readonly string _name;
        private readonly int _port;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">チャンネルの名前を指定します。</param>
        /// <param name="port">チャンネルのポート番号を指定します。</param>
        public HostIOCafeChannelInfo(string name, int port)
        {
            _name = name;
            _port = port;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// チャンネルの名前を取得します。
        /// </summary>
        public string Name
        {
            get { return _name; }
        }

        /// <summary>
        /// チャンネルのポート番号を取得します。
        /// </summary>
        public int Port
        {
            get { return _port; }
        }
    }
}
