﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.CafeSpyPlugin.Foundation.Communications
{
    /// <summary>
    /// Cafe の HostIO チャンネル関連イベントのデータを格納します。
    /// </summary>
    public class HostIOCafeChannelEventArgs : EventArgs
    {
        private readonly HostIOCafeChannelInfo _channelInfo;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="channelInfo">チャンネル情報を指定します。</param>
        public HostIOCafeChannelEventArgs(HostIOCafeChannelInfo channelInfo)
        {
            Ensure.Argument.NotNull(channelInfo);
            _channelInfo = channelInfo;
        }

        /// <summary>
        /// チャンネル情報を取得します。
        /// </summary>
        public HostIOCafeChannelInfo ChannelInfo
        {
            get { return _channelInfo; }
        }
    }
}
