﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.AudioToolKit.Xml
{
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.Foundation.Contracts;
    using System;
    using System.Xml.Serialization;

    /// <summary>
    /// ウェーブサウンドクリップリソースデータの XML モデルです。
    /// </summary>
    [XmlRoot("WaveSoundClipResource")]
    public class WaveSoundClipResourceDataXml
    {
        /// <summary>
        /// 有効性を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public bool IsEnabled { get; set; }

        /// <summary>
        /// 行数を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Row { get; set; }

        /// <summary>
        /// クリップのパスを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public string Path { get; set; }

        /// <summary>
        /// クリップの位置を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Position { get; set; }

        /// <summary>
        /// 開始オフセット（フレーム）を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int StartOffset { get; set; }

        /// <summary>
        /// 再生時間（フレーム）を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Duration { get; set; }

        /// <summary>
        /// 音量を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float Volume { get; set; }

        /// <summary>
        /// ピッチを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float Pitch { get; set; }

        /// <summary>
        /// パンを取得または設定します。
        /// </summary>
        [XmlAttribute]
        public float Pan { get; set; }

        /// <summary>
        /// データモデルから XML モデルを作成します。
        /// </summary>
        /// <returns>XML モデルを返します。</returns>
        public static WaveSoundClipResourceDataXml FromDataModel(WaveSoundClipResourceData dataModel)
        {
            Ensure.Argument.NotNull(dataModel);

            return new WaveSoundClipResourceDataXml()
            {
                IsEnabled = dataModel.IsEnabled,
                Row = dataModel.Row,
                Path = dataModel.Path,
                Position = dataModel.Position,
                StartOffset = dataModel.StartOffset,
                Duration = dataModel.Duration,
                Volume = dataModel.Volume,
                Pitch = dataModel.Pitch,
                Pan = dataModel.Pan,
            };
        }

        /// <summary>
        /// データモデルに変換します。
        /// </summary>
        /// <returns>変換後のデータモデルを返します。</returns>
        public WaveSoundClipResourceData ToDataModel()
        {
            return new WaveSoundClipResourceData()
            {
                IsEnabled = this.IsEnabled,
                Row = this.Row,
                Path = this.Path,
                Position = this.Position,
                StartOffset = this.StartOffset,
                Duration = this.Duration,
                Volume = this.Volume,
                Pitch = this.Pitch,
                Pan = this.Pan,
            };
        }
    }
}
