﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Input;

namespace Nintendo.AudioToolkit.Behaviors
{
    public static class UpdateSourceByEnterBehavior
    {
        public static readonly DependencyProperty UpdateSourceByEnterProperty =
            DependencyProperty.RegisterAttached("UpdateSourceByEnter",
            typeof(DependencyProperty),
            typeof(UpdateSourceByEnterBehavior),
            new PropertyMetadata(null, OnUpdateSourceByEnterPropertyChanged));

        public static void SetUpdateSourceByEnter(DependencyObject d, DependencyProperty value)
        {
            d.SetValue(UpdateSourceByEnterProperty, value);
        }

        public static DependencyProperty GetUpdateSourceByEnter(DependencyObject d)
        {
            return (DependencyProperty)d.GetValue(UpdateSourceByEnterProperty);
        }

        private static void OnUpdateSourceByEnterPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var element = d as UIElement;
            if (element == null)
            {
                return;
            }

            if (e.OldValue != null)
            {
                element.PreviewKeyDown -= HandlePreviewKeyDown;
            }

            if (e.NewValue != null)
            {
                element.PreviewKeyDown += new KeyEventHandler(HandlePreviewKeyDown);
            }
        }

        static void HandlePreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                DoUpdateSource(e.Source);
            }
        }

        static void DoUpdateSource(object source)
        {
            var property = GetUpdateSourceByEnter(source as DependencyObject);
            if (property == null)
            {
                return;
            }

            var element = source as UIElement;
            if (element == null)
            {
                return;
            }

            var binding = BindingOperations.GetBindingExpression(element, property);
            if (binding != null)
            {
                binding.UpdateSource();

                if (source is TextBox)
                {
                    var textBox = source as TextBox;
                    textBox.SelectAll();
                }
            }
        }
    }
}
