﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <panels/VoicePanel.h>
#include <nw/snd.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

VoicePanel::VoicePanel()
{
    SetMargin(nw::internal::dw::Thickness(0.f));

    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    m_PeakMeterContainer.SetOrientation(nw::internal::dw::HORIZONTAL);

    nw::internal::dw::UIElementList& containerItems = m_Container.GetContents();

    containerItems.AddItem(&m_VoiceCountMeter);
    containerItems.AddItem(&m_Separator);
    containerItems.AddItem(&m_PeakMeterContainer);

    m_Separator.SetDock(nw::internal::dw::DOCK_BOTTOM);
    m_Separator.SetMargin(nw::internal::dw::Thickness(2.f, 1.f));
    m_Separator.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
    m_Separator.SetHeight(0.5f);
    m_Separator.SetOrientation(nw::internal::dw::HORIZONTAL);
    m_Separator.SetBorderColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.455f, 0.486f, 0.560f, 1.f)));

    // Voice数ピークメーターの初期化
    m_VoiceCountMeter.SetDock(nw::internal::dw::DOCK_BOTTOM);
    m_VoiceCountMeter.SetMargin(nw::internal::dw::Thickness(3.f, 1.f));
    m_VoiceCountMeter.SetOrientation(nw::internal::dw::HORIZONTAL);
    m_VoiceCountMeter.SetMaximumValue(MAX_VOICE_COUNT);
    m_VoiceCountMeter.SetPeakHoldChange(1);

    // Voiceピークメーターの初期化
    m_PeakMeterContainer.SetMargin(nw::internal::dw::Thickness(2.f, 1.f));

    nw::internal::dw::UIElementList& peakMeterContainerItems = m_PeakMeterContainer.GetContents();

    for(int i=0; i<MAX_VOICE_COUNT; ++i)
    {
        PeakMeter& voiceMeter = m_VoiceMeters[i];

        voiceMeter.SetMargin(nw::internal::dw::Thickness(1.f, 1.f, 0.f, 0.f));
        voiceMeter.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
        voiceMeter.SetWidth(4);
        voiceMeter.SetVerticalAlignment(nw::internal::dw::VERTICAL_STRETCH);
        voiceMeter.SetPeakHoldFrames(0.f);

        peakMeterContainerItems.AddItem(&voiceMeter);
    }
}

void VoicePanel::OnUpdate(const nw::internal::dw::UIElementTreeContext& context)
{
    SoundSystem::SoundThreadScopedLock lock;

    u32 availableVoiceCount = 0;

    for( int ch=0;ch<MAX_VOICE_COUNT;ch++)
    {
        const nw::snd::internal::Voice* voice = nw::snd::internal::AxVoice::detail_GetVoiceById(ch)->detail_GetVoice();

        if( voice == NULL)
        {
            m_VoiceMeters[ch].SetValue(0.0f);
            continue;
        }

        if ( voice->GetState() == nw::snd::internal::VOICE_STATE_PLAY )
        {
            m_VoiceMeters[ch].SetValue(voice->GetVolume());
        }
        else
        {
            m_VoiceMeters[ch].SetValue(0.0f);
        }

        if(voice->IsAvailable())
        {
            availableVoiceCount++;
        }
    }

    m_VoiceCountMeter.SetValue(availableVoiceCount);
}

} // snd
} // nw
