﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <resources/GlobalResources.h>
#include <panels/SoundSystemPanel.h>

namespace nw {
namespace snd {

static const nw::snd::OutputMode s_OutputModes[] =
{
    nw::snd::OUTPUT_MODE_MONO,
    nw::snd::OUTPUT_MODE_STEREO,
    nw::snd::OUTPUT_MODE_SURROUND,
};

static nw::snd::OutputMode GetOutputModeMain(void*)
{
    return nw::snd::SoundSystem::GetOutputMode(OUTPUT_DEVICE_MAIN);
}

static void SetOutputModeMain(void*, nw::snd::OutputMode value)
{
    nw::snd::SoundSystem::SetOutputMode(value, OUTPUT_DEVICE_MAIN);
}

static nw::snd::OutputMode GetOutputModeDrc(void*)
{
    return nw::snd::SoundSystem::GetOutputMode(OUTPUT_DEVICE_DRC);
}

static void SetOutputModeDrc(void*, nw::snd::OutputMode value)
{
    nw::snd::SoundSystem::SetOutputMode(value, OUTPUT_DEVICE_DRC);
}

static void PrintOutputMode(char* pText, u32 bufferLength, nw::snd::OutputMode value)
{
    const char* pValueText = "";

    switch(value)
    {
    case nw::snd::OUTPUT_MODE_MONO:
        pValueText = "MONO";
        break;

    case nw::snd::OUTPUT_MODE_STEREO:
        pValueText = "STEREO";
        break;

    case nw::snd::OUTPUT_MODE_SURROUND:
        pValueText = "SURROUND";
        break;
    }

    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%s", pValueText);
}

SoundSystemPanel::SoundSystemPanel() :
m_OutputModeMain(nw::snd::OUTPUT_MODE_STEREO),
m_OutputModeDrc(nw::snd::OUTPUT_MODE_STEREO)
{
    SetMargin(nw::internal::dw::Thickness(0.f));

    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    m_OutputModeMain.SetLabelWidth(80.f);
    m_OutputModeDrc.SetLabelWidth(80.f);
    AddItem(m_OutputModeMain);
    AddItem(m_OutputModeDrc);

    m_OutputModeMain.Initialize(
        s_OutputModes,
        sizeof(s_OutputModes) / sizeof(s_OutputModes[0]),
        GetOutputModeMain,
        SetOutputModeMain,
        PrintOutputMode
        );
    m_OutputModeMain.SetLabelText("OutputMode(Main):");

    m_OutputModeDrc.Initialize(
        s_OutputModes,
        sizeof(s_OutputModes) / sizeof(s_OutputModes[0]),
        GetOutputModeDrc,
        SetOutputModeDrc,
        PrintOutputMode
        );
    m_OutputModeDrc.SetLabelText("OutputMode(DRC):");

    // 何かモデルを設定しないと動作しないので、ダミーで this を設定
    m_OutputModeMain.SetModel(this);
    m_OutputModeDrc.SetModel(this);

    // 最初の項目を選択します。
    if(m_Container.GetItemCount() > 0)
    {
        m_Container.GetItemPlaceHolder(0).SetIsSelected(true);
    }
}

SoundSystemPanel::~SoundSystemPanel()
{
}

void SoundSystemPanel::AddItem(nw::internal::dw::UIElement& item)
{
    u32 index = m_Container.GetItemCount();
    NW_ASSERT(index < MAX_ITEM_COUNT);

    m_pListItems[index] = &item;
    m_Container.AddItem(&item);
}

} // snd
} // nw
