﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <models/PreviewEffectUtility.h>

namespace nw {
namespace snd {

const char* PreviewEffectUtility::ToString(PreviewEffectType value)
{
    switch(value)
    {
    case EFFECT_NONE:
        return "None";

    case EFFECT_REVERB_HI:
        return "ReverbHigh";

    case EFFECT_REVERB_STD:
        return "ReverbStandard";

    case EFFECT_CHORUS:
        return "Chorus";

    case EFFECT_DELAY:
        return "Delay";

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    case EFFECT_MULTICH_REVERB:
        return "MultiChannelReverb";

    case EFFECT_MULTICH_CHORUS:
        return "MultiChannelChorus";

    case EFFECT_MULTICH_DELAY:
        return "MultiChannelDelay";
#endif
    }

    return "";
}

const char* PreviewEffectUtility::ToShortString(PreviewEffectType value)
{
    switch(value)
    {
    case EFFECT_NONE:
        return "None";

    case EFFECT_REVERB_HI:
        return "RevHi";

    case EFFECT_REVERB_STD:
        return "RevStd";

    case EFFECT_CHORUS:
        return "Chorus";

    case EFFECT_DELAY:
        return "Delay";

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    case EFFECT_MULTICH_REVERB:
        return "MCRev";

    case EFFECT_MULTICH_CHORUS:
        return "MCChorus";

    case EFFECT_MULTICH_DELAY:
        return "MCDelay";
#endif
    }

    return "";
}

} // nw::snd
} // nw
